using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class snowmanAI : MonoBehaviour
{
    public Animator animator;
    float speed = 5f;
    private Transform target;
    public Vector3 targetPosition;


    // Use this for initialization
    void Start () 
    {
        target = GameObject.FindGameObjectWithTag("Player").GetComponent<Transform>(); 
    }

    private void OnTriggerEnter(Collider other)
    {
        animator.SetTrigger("Battlecry");
        Invoke ("Attack", 2f);
    }

    private void Attack()
    {
        animator.SetTrigger("Run");
        targetPosition = new Vector3(target.position.x, 0.0f, target.position.z);
        transform.position = Vector3.MoveTowards(transform.position, targetPosition, speed * Time.deltaTime);

    }

    // Update is called once per frame
    void Update () 
    {
        if (Input.GetKeyDown(KeyCode.J)) 
        {
            animator.SetTrigger("Idle");
        }
    }
}